SET QUOTED_IDENTIFIER ON

GO

EXEC MES.Test @Force = 1


SET NOCOUNT ON;
PRINT 'Starting RBD Post-Deployment Initialization...';

DECLARE @proc VARCHAR(100) = 'PostDeployment-Initialize';

-- =============================================
-- ASSET CONFIGURATION
-- =============================================
PRINT '  Configuring assets...';
UPDATE MES.catAssets SET AssetName = 'RBD Mill' WHERE AssetId = 1;

-- =============================================
-- SETTINGS
-- =============================================
PRINT '  Configuring settings...';

-- DAYS_BACK_DELAYS: How many days back to sync delays from legacy database
IF NOT EXISTS (SELECT 1 FROM UTL.catSettings WHERE SettingName = 'DAYS_BACK_DELAYS')
    INSERT INTO UTL.catSettings (SettingName, [Value], [Description])
    VALUES ('DAYS_BACK_DELAYS', '30', 'Number of days to look back when syncing delays from legacy database');

-- DefaultDelayAreaAssetId: Default delay area for UpsertDelayCategory and UpsertDelayCode
IF NOT EXISTS (SELECT 1 FROM UTL.catSettings WHERE SettingName = 'DefaultDelayAreaAssetId')
    INSERT INTO UTL.catSettings (SettingName, [Value], [Description])
    VALUES ('DefaultDelayAreaAssetId', '1', 'Default delay area for UpsertDelayCategory and UpsertDelayCode');

-- FF_LOGBOOK_ENABLED: Feature flag for Logbook menu visibility (1 = enabled, 0 = disabled)
IF NOT EXISTS (SELECT 1 FROM UTL.catSettings WHERE SettingName = 'FF_LOGBOOK_ENABLED')
    INSERT INTO UTL.catSettings (SettingName, [Value], [Description])
    VALUES ('FF_LOGBOOK_ENABLED', '1', 'Feature Flag for Logbook');

-- FF_SPLIT_DELAY_ENABLED: Feature flag for Split Delay functionality (1 = enabled, 0 = disabled)
IF NOT EXISTS (SELECT 1 FROM UTL.catSettings WHERE SettingName = 'FF_SPLIT_DELAY_ENABLED')
    INSERT INTO UTL.catSettings (SettingName, [Value], [Description])
    VALUES ('FF_SPLIT_DELAY_ENABLED', '0', 'Feature Flag for Split Delay functionality in Stops Manager');

-- FF_PASSING_THE_BALL_ENABLED: Feature flag for Passing the Ball workflow (1 = enabled, 0 = disabled)
IF NOT EXISTS (SELECT 1 FROM UTL.catSettings WHERE SettingName = 'FF_PASSING_THE_BALL_ENABLED')
    INSERT INTO UTL.catSettings (SettingName, [Value], [Description])
    VALUES ('FF_PASSING_THE_BALL_ENABLED', '1', 'Feature Flag for Passing the Ball workflow (auto-popup for delay classification handoff)');

-- DELAY_POPUP_REOPEN_SECONDS: Time in seconds before auto-reopening delay popup after user dismisses it
IF NOT EXISTS (SELECT 1 FROM UTL.catSettings WHERE SettingName = 'DELAY_POPUP_REOPEN_SECONDS')
    INSERT INTO UTL.catSettings (SettingName, [Value], [Description])
    VALUES ('DELAY_POPUP_REOPEN_SECONDS', '30', 'Time in seconds before auto-reopening delay popup if user navigates away without declaring');

-- =============================================
-- DELAY AREAS
-- =============================================
PRINT '  Configuring delay areas...';
-- Configure which assets are delay areas (required for DEL schema)
IF NOT EXISTS (SELECT 1 FROM DEL.catAssetsExtension WHERE AssetId = 1)
    INSERT INTO DEL.catAssetsExtension (AssetId, IsDelayArea) VALUES (1, 1);
ELSE
    UPDATE DEL.catAssetsExtension SET IsDelayArea = 1 WHERE AssetId = 1;

-- =============================================
-- PASSING THE BALL - BRANCH PERMISSIONS
-- =============================================
PRINT '  Configuring Passing the Ball permissions...';

-- Create Actions (permissions) for the workflow
-- Permission for general operators (see undeclared delays)
IF NOT EXISTS (SELECT 1 FROM SYSTEM.catActions WHERE ActionName = 'undeclaredstop_showDelaysPopup')
    INSERT INTO SYSTEM.catActions (ActionName) VALUES ('undeclaredstop_showDelaysPopup');

-- Permissions for specialists of each area
IF NOT EXISTS (SELECT 1 FROM SYSTEM.catActions WHERE ActionName = 'millstopdeclare_showDelaysPopup')
    INSERT INTO SYSTEM.catActions (ActionName) VALUES ('millstopdeclare_showDelaysPopup');

IF NOT EXISTS (SELECT 1 FROM SYSTEM.catActions WHERE ActionName = 'reheatfurnacestopdeclare_showDelaysPopup')
    INSERT INTO SYSTEM.catActions (ActionName) VALUES ('reheatfurnacestopdeclare_showDelaysPopup');

IF NOT EXISTS (SELECT 1 FROM SYSTEM.catActions WHERE ActionName = 'shearstopdeclare_showDelaysPopup')
    INSERT INTO SYSTEM.catActions (ActionName) VALUES ('shearstopdeclare_showDelaysPopup');

IF NOT EXISTS (SELECT 1 FROM SYSTEM.catActions WHERE ActionName = 'stackerstopdeclare_showDelaysPopup')
    INSERT INTO SYSTEM.catActions (ActionName) VALUES ('stackerstopdeclare_showDelaysPopup');

IF NOT EXISTS (SELECT 1 FROM SYSTEM.catActions WHERE ActionName = 'bundlerstopdeclare_showDelaysPopup')
    INSERT INTO SYSTEM.catActions (ActionName) VALUES ('bundlerstopdeclare_showDelaysPopup');

IF NOT EXISTS (SELECT 1 FROM SYSTEM.catActions WHERE ActionName = 'cranesstopdeclare_showDelaysPopup')
    INSERT INTO SYSTEM.catActions (ActionName) VALUES ('cranesstopdeclare_showDelaysPopup');

-- Assign Passing the Ball permissions to admin Profile
DECLARE @AdminProfileId INT = (SELECT ProfileId FROM SEC.catProfiles WHERE ProfileName = 'admin Profile');

IF @AdminProfileId IS NOT NULL
BEGIN
    -- OPERATOR PERMISSION: See popup for undeclared delays (can only select branch codes)
    INSERT INTO SEC.catProfilesActions (ProfileId, ActionId)
    SELECT @AdminProfileId, ActionId
    FROM SYSTEM.catActions
    WHERE ActionName = 'undeclaredstop_showDelaysPopup'
    AND NOT EXISTS (
        SELECT 1 FROM SEC.catProfilesActions pa
        WHERE pa.ProfileId = @AdminProfileId
        AND pa.ActionId = SYSTEM.catActions.ActionId
    );

    -- SPECIALIST PERMISSIONS: Each specialist sees popup for their branch and can select child codes
    INSERT INTO SEC.catProfilesActions (ProfileId, ActionId)
    SELECT @AdminProfileId, ActionId
    FROM SYSTEM.catActions
    WHERE ActionName IN (
        'millstopdeclare_showDelaysPopup',
        'reheatfurnacestopdeclare_showDelaysPopup',
        'shearstopdeclare_showDelaysPopup',
        'stackerstopdeclare_showDelaysPopup',
        'bundlerstopdeclare_showDelaysPopup',
        'cranesstopdeclare_showDelaysPopup'
    )
    AND NOT EXISTS (
        SELECT 1 FROM SEC.catProfilesActions pa
        WHERE pa.ProfileId = @AdminProfileId
        AND pa.ActionId = SYSTEM.catActions.ActionId
    );
END

-- Configure Branch Codes with their permission actions
-- Links branch codes to SYSTEM.catActions via DEL.catDelayCodesBranchPermissions
-- Branch codes are root-level codes (ParentDelayCodeId = -1)

INSERT INTO DEL.catDelayCodesBranchPermissions (DelayCodeId, ActionId)
SELECT dc.DelayCodeId, a.ActionId
FROM DEL.catDelayCodes dc
CROSS JOIN [SYSTEM].catActions a
WHERE dc.DelayCodeName = 'Mill' AND dc.ParentDelayCodeId = -1
  AND a.ActionName = 'millstopdeclare_showDelaysPopup'
  AND NOT EXISTS (SELECT 1 FROM DEL.catDelayCodesBranchPermissions WHERE DelayCodeId = dc.DelayCodeId);

INSERT INTO DEL.catDelayCodesBranchPermissions (DelayCodeId, ActionId)
SELECT dc.DelayCodeId, a.ActionId
FROM DEL.catDelayCodes dc
CROSS JOIN [SYSTEM].catActions a
WHERE dc.DelayCodeName = 'Reheat Furnace' AND dc.ParentDelayCodeId = -1
  AND a.ActionName = 'reheatfurnacestopdeclare_showDelaysPopup'
  AND NOT EXISTS (SELECT 1 FROM DEL.catDelayCodesBranchPermissions WHERE DelayCodeId = dc.DelayCodeId);

INSERT INTO DEL.catDelayCodesBranchPermissions (DelayCodeId, ActionId)
SELECT dc.DelayCodeId, a.ActionId
FROM DEL.catDelayCodes dc
CROSS JOIN [SYSTEM].catActions a
WHERE dc.DelayCodeName = 'Shear/Straightener' AND dc.ParentDelayCodeId = -1
  AND a.ActionName = 'shearstopdeclare_showDelaysPopup'
  AND NOT EXISTS (SELECT 1 FROM DEL.catDelayCodesBranchPermissions WHERE DelayCodeId = dc.DelayCodeId);

INSERT INTO DEL.catDelayCodesBranchPermissions (DelayCodeId, ActionId)
SELECT dc.DelayCodeId, a.ActionId
FROM DEL.catDelayCodes dc
CROSS JOIN [SYSTEM].catActions a
WHERE dc.DelayCodeName = 'Stacker' AND dc.ParentDelayCodeId = -1
  AND a.ActionName = 'stackerstopdeclare_showDelaysPopup'
  AND NOT EXISTS (SELECT 1 FROM DEL.catDelayCodesBranchPermissions WHERE DelayCodeId = dc.DelayCodeId);

INSERT INTO DEL.catDelayCodesBranchPermissions (DelayCodeId, ActionId)
SELECT dc.DelayCodeId, a.ActionId
FROM DEL.catDelayCodes dc
CROSS JOIN [SYSTEM].catActions a
WHERE dc.DelayCodeName = 'Bundler' AND dc.ParentDelayCodeId = -1
  AND a.ActionName = 'bundlerstopdeclare_showDelaysPopup'
  AND NOT EXISTS (SELECT 1 FROM DEL.catDelayCodesBranchPermissions WHERE DelayCodeId = dc.DelayCodeId);

INSERT INTO DEL.catDelayCodesBranchPermissions (DelayCodeId, ActionId)
SELECT dc.DelayCodeId, a.ActionId
FROM DEL.catDelayCodes dc
CROSS JOIN [SYSTEM].catActions a
WHERE dc.DelayCodeName = 'Cranes' AND dc.ParentDelayCodeId = -1
  AND a.ActionName = 'cranesstopdeclare_showDelaysPopup'
  AND NOT EXISTS (SELECT 1 FROM DEL.catDelayCodesBranchPermissions WHERE DelayCodeId = dc.DelayCodeId);

PRINT '  Passing the Ball permissions configured.';

-- =============================================
-- PERMISSIONS
-- =============================================
PRINT '  Configuring permissions...';
-- Note: Base permissions (LB, MES, SEC, UTL) are in mesf-core MES.Test

-- MILL Schema Procedures (merged from CAT + RFAC)
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[AssignRollToRollset]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[ChangePass]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[ChangeRollset]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[ChangeWorkOrder]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[CreateAccountSummary]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[CreateRecipeEmpty]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[CreateRecipeFromBilletsTracked]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[CreateRollsProduction]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[CutRolls]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[DeclareDelay]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[DeleteManualStop]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[DeleteProductChanges]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[DeleteRoll]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[DuplicateRecipe]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[EndCampaign]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[GetAccountSummary]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[GetAccountSummaryByClose]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[GetAccountSummaryCloseDates]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[GetBarrels]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[GetBillets]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[GetBilletSizes]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[GetBilletsProcessDataWeb]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[GetBilletsProcessPickersDataWeb]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[GetBilletsRFactorDataWeb]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[GetBilletsRFactorPickersDataWeb]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[GetBilletWorkOrdersDataWeb]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[GetBilletWorkOrdersPickersDataWeb]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[GetCampaignProductsWithWrongPassDataWeb]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[GetCampaigns]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[GetCampaignsMeta]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[GetCartridges]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[GetCobbles]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[GetCobblesDataWeb]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[GetCobblesPickersDataWeb]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[GetCostCenters]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[GetCurrentCampaign]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[GetCurrentDelayWeb]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[GetCurrentDelayWeb_New]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[GetCurrentRollingMillSetupStands]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[GetDelays]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[GetFirstTurnedRollsDataWeb]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[GetFutureCampaigns]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[GetInformationRetrievalDataWeb]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[GetLastTurnedRollsDataWeb]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[GetMillSetupSheet]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[GetMillSizes]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[GetNewRollsDataWeb]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[GetOperators]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[GetOrderStatus]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[GetPartialRollsets]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[GetPassChanges]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[GetPassChangesDataWeb]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[GetPassChangesPickersDataWeb]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[GetPassIds]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[GetPassShapes]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[GetPassStatus]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[GetPassTypes]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[GetProductChanges]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[GetProductChangesPickers]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[GetProductChangesReport]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[GetProductChangesReportPickers]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[GetProductMillSetup]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[GetProductsHistoryDataWeb]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[GetProductsHistoryPickersDataWeb]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[GetProductSizes]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[GetProductsWithoutRecipeDataWeb]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[GetProductTypes]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[GetRecipes]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[GetRecipesDataWeb]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[GetRecipesMeta]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[GetRecipeStandRFactorsDataWeb]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[GetRecipeStands]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[GetRecipeStandsDataWeb]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[GetReturnedRollsDataWeb]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[GetRFactorPerProdStand]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[GetRFactorPerStandPickersDataWeb]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[GetRMShiftReport]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[GetRollApplications]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[GetRollCuts]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[GetRollingMillSetupCampaignDataWeb]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[GetRollingMillSetupLastBilletsDataWeb]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[GetRollingMillSetupStandsDataWeb]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[GetRollMaterials]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[GetRolls]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[GetRollsCartridgeDataWeb]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[GetRollsets]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[GetRollsetStatus]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[GetRollsInUseDataWeb]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[GetRollsProduction]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[GetRollStatus]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[GetShiftReport]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[GetShiftReportPickers]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[GetShiftsProductionDataWeb]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[GetShiftsProductionDataWeb2]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[GetStands]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[GetStatsPerProductSize]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[GetStopsDataWeb]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[GetStopsPickersDataWeb]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[GetStraightenerReport]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[GetStraightenerReportPickers]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[GetStraightenerRuns]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[GetStraightenerRunsReport]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[GetSuppliers]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[GetTrackingSignals]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[GetTrendDisplayDataWeb]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[GetWorkOrders]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[ImportTagScans]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[ImportWorkOrders]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[PrepareRollForLine]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[RecalculateProductChangesTime]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[RemoveRecipe]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[RemoveRollFromRollset]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[ResetTemporalBilletsCount]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[SetRollsetStatus]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[SetRollsetStatusInternal]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[SetRollStatusInternal]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[SplitDelay]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[StartCampaign]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[TimerSpeedReport]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[TrackBilletData]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[TrackBilletInStands]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[TrackBilletsEnd]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[TrackBilletsStart]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[TrackBilletStandData]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[TrackCobblesOnStop]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[TrackCobblesWithCobbleSignalAndShear]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[TrackDelays]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[TrackDelays_New]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[TrackLastGap]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[TrackRollsProductionByStand]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[UndoPrepareRollForLine]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[UpdateCampaign]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[UpdateRollRequests]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[UpdateRollsProduction]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[UpsertBilletWorkOrder]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[UpsertManualStop]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[UpsertManualStop_New]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[UpsertMillSetupSheet]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[UpsertProductChanges]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[UpsertRecipe]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[UpsertRoll]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[UpsertRollset]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[UpsertWorkOrder]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[ValidateBillet]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[ValidateCampaign]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[ValidateDeclareDelay]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[ValidatePassChange]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[ValidateRecipe]', 'admin Profile', @proc;

-- KPI Schema Procedures
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[KPI].[GetBilletsBetweenCobblesDataWeb]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[KPI].[GetBilletsBetweenCobblesPickersDataWeb]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[KPI].[GetShiftKPIWeb]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[KPI].[UpsertCampaignsFactTable]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[KPI].[UpsertProductionFactTable]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[KPI].[UpsertStraightenerRuns]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[KPI].[UpsertTagScansFactTable]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[KPI].[UpsertTimesFactTable]', 'admin Profile', @proc;

-- SAL Schema Procedures
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[SAL].[GetForecastReport]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[SAL].[GetMonthlyEstimation]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[SAL].[UpdateMonthlyData]', 'admin Profile', @proc;

-- DEL Schema Procedures (Delays)
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[DEL].[ChangeParentDelayCode]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[DEL].[CloseDelay]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[DEL].[DeleteDelayCategory]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[DEL].[DeleteDelayCode]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[DEL].[DeleteManualDelay]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[DEL].[GetAssetsForDelayArea]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[DEL].[GetDelay]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[DEL].[GetDelayAreas]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[DEL].[GetDelayCategories]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[DEL].[GetDelayCategory]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[DEL].[GetDelayCode]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[DEL].[GetDelayCodes]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[DEL].[GetDelays]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[DEL].[GetDelaysByShift]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[DEL].[GetDelaysForPareto]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[DEL].[JoinPreviousDelay]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[DEL].[JustifyDelay]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[DEL].[MoveDelayCode]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[DEL].[OpenDelay]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[DEL].[ReorderDelayCode]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[DEL].[SpliceDelaysByShiftJob]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[DEL].[SplitDelay]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[DEL].[UpsertDelayCategory]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[DEL].[UpsertDelayCode]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[DEL].[UpsertManualDelay]', 'admin Profile', @proc;

-- RBD Schema Procedures (Sync Jobs)
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[RBD].[SyncCatalogsTableJob]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[RBD].[SyncDelaysJob]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[RBD].[SyncLogbookJob]', 'admin Profile', @proc;

-- UI Permissions
EXEC [SEC].[UpsertProcedureAndSetToProfile] 'ui.navbar.settings', 'admin Profile', @proc;

PRINT 'RBD Post-Deployment Initialization completed successfully.';
GO

-- First job executions
EXEC [RBD].[SyncCatalogsTableJob]
EXEC [RBD].[SyncDelaysJob]

-- Initialize Jobs
EXEC SYSTEM.InitializeJob @sProcedure = '[RBD].[SyncCatalogsTableJob]', @PeriodTime = 3600;
EXEC SYSTEM.InitializeJob @sProcedure = '[RBD].[SyncDelaysJob]', @PeriodTime = 5;
EXEC SYSTEM.InitializeJob @sProcedure = '[RBD].[SyncLogbookJob]', @PeriodTime = 600;
EXEC SYSTEM.InitializaJob @sProcedure = '[RBD].[SyncUsersAndProfilesJob]', @PeriodTime = 600;
