SET QUOTED_IDENTIFIER ON

GO

SET NOCOUNT ON;

DECLARE @proc VARCHAR(100) = 'PostDeployment-Initialize';

-- ============================================
-- BARRELS CRUD
-- ============================================
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[GetBarrels]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[UpsertBarrel]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[RemoveBarrel]', 'admin Profile', @proc;

-- Barrel Layouts
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[UpsertBarrelLayout]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[RemoveBarrelLayout]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[ReorderBarrelLayout]', 'admin Profile', @proc;

-- Barrel Attachments
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[GetBarrelAttachments]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[UpsertBarrelAttachment]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[DeleteBarrelAttachment]', 'admin Profile', @proc;

-- ============================================
-- PASS TYPES CRUD
-- ============================================
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[GetPassTypes]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[UpsertPassType]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[RemovePassType]', 'admin Profile', @proc;

-- ============================================
-- PASS IDS CRUD
-- ============================================
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[GetPassIds]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[UpsertPassId]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[RemovePassId]', 'admin Profile', @proc;

-- ============================================
-- CARTRIDGES CRUD
-- ============================================
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[GetCartridges]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[UpsertCartridge]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[RemoveCartridge]', 'admin Profile', @proc;

-- ============================================
-- PASS CHANGE REASONS CRUD
-- ============================================
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[GetPassChangeReasons]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[UpsertPassChangeReason]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[RemovePassChangeReason]', 'admin Profile', @proc;

-- ============================================
-- LOOKUPS / DROPDOWNS
-- ============================================
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[GetStands]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[GetPassShapes]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[GetRollMaterials]', 'admin Profile', @proc;
EXEC [SEC].[UpsertProcedureAndSetToProfile] '[MILL].[GetMillSizes]', 'admin Profile', @proc;

-- ============================================
-- SCHEDULED JOBS
-- ============================================
-- Remove deprecated sync jobs (replaced by SyncAllCatalogsJob)
DELETE FROM [SYSTEM].[catJobs] WHERE sProcedure = '[RBD].[SyncCatalogsTableJob]';
DELETE FROM [SYSTEM].[catJobs] WHERE sProcedure = '[RBD].[SyncRFactorCatalogsJob]';

-- Sync all catalogs from legacy database every hour
EXEC [SYSTEM].[UpsertJob]
    @sProcedure = '[RBD].[SyncAllCatalogsJob]',
    @StartTime = '2026-01-27 08:00:00',
    @PeriodTime = 3600,
    @RestartAfterFailure = 1,
    @User = @proc;

GO
