# Release-specific deployment configuration
# This file is packaged with each release in database/deploy-config.ps1
# Jenkins copies this file into the release zip during build

$deployConfig = @{
    # Site
    SiteName            = "RBD-MILL"
    AppSubfolder        = "app"
    
    # Database (connection string comes from shared/appsettings.json)
    TargetDatabaseName  = "rbd-mill"
    
    # Notifications
    GoogleChatEndpoint  = "https://chat.googleapis.com/v1/spaces/AAQAigu7zpI/messages?key=AIzaSyDdI0hCZtE6vySjMm-WEfRq3CPzqKqqsHI&token=vo7s61lya9Kh1xK_baro-va5uboPIbsaX8u6hKc1qOY"
    N8nWebhook          = "https://n8n.2.dev.dexteel.com/webhook/logs"
    N8nSpaceId          = "019b1409-360c-7906-8d82-eda8764cd5d5"
    N8nParentPageId     = "019be1e1-c272-714c-b6f5-b71a615cda89"
    
    # DACPACs to deploy (in order, based on schema dependencies)
    # Format: @{Name="dacpac-name"; TargetDB="database"; EnvVars=@("/v:var=value")}
    # Dependency chain: mesf-core -> del -> mill -> kpi -> sal -> rbd
    Dacpacs = @(
        @{Name="historian-sql"; TargetDB="historian"; EnvVars=@()},
        @{Name="mesf-core-sql-sql140"; TargetDB="rbd-mill"; EnvVars=@()},
        @{Name="del-sql"; TargetDB="rbd-mill"; EnvVars=@("/v:historian=historian")},
        @{Name="mill-sql"; TargetDB="rbd-mill"; EnvVars=@()},
        @{Name="forms-sql"; TargetDB="rbd-mill"; EnvVars=@()},
        @{Name="kpi-sql"; TargetDB="rbd-mill"; EnvVars=@()},
        @{Name="sal-sql"; TargetDB="rbd-mill"; EnvVars=@()},
        @{Name="rbd-sql"; TargetDB="rbd-mill"; EnvVars=@("/v:historian=historian", "/v:LOGBOOK=LOGBOOK", "/v:RFAC_LEGACY=R-FactorSystem", "/v:MILL_SERVER_LEGACY=MillMES", "/v:IHBOX_SYSTEM=IHBoxSystem")}
    )
}
