# Release-specific deployment configuration
# This file is packaged with each release in database/deploy-config.ps1
# Jenkins copies this file into the release zip during build

$deployConfig = @{
    # Site
    SiteName            = "RBD-MILL"
    AppSubfolder        = "app"
    
    # Database (connection string comes from shared/appsettings.json)
    TargetDatabaseName  = "rbd-mill"
    
    # Notifications
    GoogleChatEndpoint  = "vhttps://chat.googleapis.com/v1/spaces/AAQAWx9zkj4/messages?key=AIzaSyDdI0hCZtE6vySjMm-WEfRq3CPzqKqqsHI&token=4CsB5yBAoHSoI662FomPQgkYhHim4Y2lgWPxJdT5Vn0"
    N8nWebhook          = "https://n8n.2.dev.dexteel.com/webhook/logs"
    N8nSpaceId          = "019b1409-360c-7906-8d82-eda8764cd5d5"
    N8nParentPageId     = "019be1e1-c272-714c-b6f5-b71a615cda89"
    
    # DACPACs to deploy (in order, based on schema dependencies)
    # Format: @{Name="dacpac-name"; TargetDB="database"; EnvVars=@("/v:var=value")}
    Dacpacs = @(
        @{Name="historian-sql"; TargetDB="historian"; EnvVars=@()},
        @{Name="mesf-core-sql-sql140"; TargetDB="rbd-mill"; EnvVars=@()},
        @{Name="cat-sql"; TargetDB="rbd-mill"; EnvVars=@("/v:historian=historian")},
        @{Name="del-sql"; TargetDB="rbd-mill"; EnvVars=@("/v:historian=historian")},
        @{Name="forms-sql"; TargetDB="rbd-mill"; EnvVars=@()},
        @{Name="rfac-sql"; TargetDB="rbd-mill"; EnvVars=@("/v:historian=historian")},
        @{Name="kpi-sql"; TargetDB="rbd-mill"; EnvVars=@()},
        @{Name="sal-sql"; TargetDB="rbd-mill"; EnvVars=@()},
        @{Name="rbd-sql"; TargetDB="rbd-mill"; EnvVars=@("/v:historian=historian", "/v:LOGBOOK=LOGBOOK")}
    )
}
